<?php
/**
 * WHMCS N Kolay Payment Callback File
 *
 * This file handles the callback requests from the N Kolay payment gateway.
 */

// Require libraries needed for gateway module functions.
require_once __DIR__ . '/../../../init.php';
require_once __DIR__ . '/../../../includes/gatewayfunctions.php';
require_once __DIR__ . '/../../../includes/invoicefunctions.php';

// Detect module name from filename.
$gatewayModuleName = basename(__FILE__, '.php');

// Fetch gateway configuration parameters.
$gatewayParams = getGatewayVariables($gatewayModuleName);

// Die if module is not active.
if (!$gatewayParams['type']) {
    die("Module Not Activated");
}

// Retrieve POST data
$referenceCode = $_POST['REFERENCE_CODE'] ?? '';
$responseCode = $_POST['RESPONSE_CODE'] ?? '';
$use3D = $_POST['USE_3D'] ?? '';
$merchantNumber = $_POST['MERCHANT_NO'] ?? '';
$authCode = $_POST['AUTH_CODE'] ?? '';
$clientRefCode = $_POST['CLIENT_REFERENCE_CODE'] ?? '';
$authorizationAmount = $_POST['AUTHORIZATION_AMOUNT'] ?? '';
$installment = $_POST['INSTALLMENT'] ?? '';
$rnd = $_POST['RND'] ?? '';
$receivedHashData = $_POST['hashData'] ?? '';
$responseData = $_POST['RESPONSE_DATA'] ?? '';
// echo "<pre>". print_r($_POST)  ."</pre>";
// echo $receivedHashData . "<br>";


$merchantSecretKey = $gatewayParams['secretKey'];

// Extract invoice ID from client reference code
$invoiceIdParts = explode('WHMCS', $clientRefCode);
$invoiceId = current($invoiceIdParts);

// Generate hash to validate callback
$hashString = $merchantNumber . $referenceCode . $authCode . $responseCode . $use3D . $rnd . $installment . $authorizationAmount . $merchantSecretKey;
$generatedHashData = base64_encode(pack('H*', sha1($hashString)));

// echo $generatedHashData . "<br>";
// die();
// Check if referenceCode is more than 32 characters, add error to $_POST and set failure
$success = false;
if (strlen($referenceCode) > 32) {
    $_POST = array_merge(['ERROR_INFORMATION' => "Dikkat: İşleminiz bu şekilde tamamlanamamaktadır! Ödeme alabilmek için otomatik tamamlama gerekmektedir. Lütfen detaylı bilgi ve destek için PayNkolay ile iletişime geçiniz."], $_POST);
    $failure = 'PayNKolay hesabınızda Otomatik Tamamlama Aktif Değil';
} else {
    // Verify the hash and response code
    if (($use3D === 'false' && $receivedHashData === $generatedHashData && $responseCode == 2 && $authCode) ||
        ($receivedHashData === $generatedHashData && $responseCode == 2 && $authCode)) {
        $success = true;
        //$failure = $responseData ?? '';
    } else {
        $success = false;
        $failure = $responseData ?? '';
    }
}

// Transaction details
$transactionId = $clientRefCode;
$paymentAmount = $authorizationAmount;
$paymentFee = 0; // Optional

$transactionStatus = $success ? 'Success' : $failure;


/**
 * Validate Callback Invoice ID.
 *
 * Checks invoice ID is a valid invoice number. Note it will count an
 * invoice in any status as valid.
 *
 * @param int $invoiceId Invoice ID
 * @param string $gatewayName Gateway Name
 */
$invoiceId = checkCbInvoiceID($invoiceId, $gatewayParams['name']);

/**
 * Check Callback Transaction ID.
 *
 * Performs a check for any existing transactions with the same given
 * transaction number.
 *
 * @param string $transactionId Unique Transaction ID
 */
checkCbTransID($transactionId);

/**
 * Log Transaction.
 *
 * Add an entry to the Gateway Log for debugging purposes.
 *
 * @param string $gatewayName        Display label
 * @param string|array $debugData    Data to log
 * @param string $transactionStatus  Status
 */
logTransaction($gatewayParams['name'], $_POST, $transactionStatus);

$paymentSuccess = false;
if ($success) {
    /**
     * Add Invoice Payment.
     *
     * Applies a payment transaction entry to the given invoice ID.
     *
     * @param int $invoiceId         Invoice ID
     * @param string $transactionId  Transaction ID
     * @param float $paymentAmount   Amount paid (defaults to full balance)
     * @param float $paymentFee      Payment fee (optional)
     * @param string $gatewayModule  Gateway module name
     */
    addInvoicePayment(
        $invoiceId,
        $transactionId,
        $paymentAmount,
        $paymentFee,
        $gatewayModuleName
    );
    $paymentSuccess = true;
}

/**
 * Redirect to invoice.
 *
 * Performs redirect back to the invoice upon completion of the 3D Secure
 * process displaying the transaction result along with the invoice.
 *
 * @param int $invoiceId        Invoice ID
 * @param bool $paymentSuccess  Payment status
 */
callback3DSecureRedirect($invoiceId, $paymentSuccess);

/**
 * Ensure compatibility with PHP 7 and 8
 */
function ensureCompat($var, $default = '') {
    return $var ?? $default;
}
