<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

/**
 * Define module related meta data.
 *
 * @return array
 */
function nkolay_MetaData() {
    return array(
        'DisplayName' => 'N Kolay Payment Gateway',
        'APIVersion' => '1.1', // Use API Version 1.1
    );
}

/**
 * Define gateway configuration options.
 *
 * @return array
 */
function nkolay_config() {
    return array(
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'N Kolay Payment Gateway',
        ),
        'apiKey' => array(
            'FriendlyName' => 'SX Key',
            'Type' => 'text',
            'Size' => '255',
            'Default' => '',
            'Description' => 'Enter your SX key',
        ),
        'secretKey' => array(
            'FriendlyName' => 'Merchant Secret Key',
            'Type' => 'text',
            'Size' => '255',
            'Default' => '',
            'Description' => 'Enter your merchant secret key',
        ),
        'instalment' => array(
            'FriendlyName' => 'Maksimum Taksit Sayısı',
            'Type' => 'text',
            'Size' => '2',
            'Default' => '',
            'Description' => 'Taksit sayısını sınırlandırmak için bir değer girin. (Boş bırakılırsa bankaların taksit sayısı kullanılır.)',
        ),
        'threeDMode' => array(
            'FriendlyName' => '3D Secure Mode',
            'Type' => 'yesno',
            'Description' => 'Enable 3D Secure mode if checked',
        ),
        'testMode' => array(
            'FriendlyName' => 'Test Mode',
            'Type' => 'yesno',
            'Description' => 'Enable test mode if checked',
        ),
    );
}

/**
 * Payment link.
 *
 * Defines the HTML output displayed on an invoice.
 *
 * @param array $params Payment Gateway Module Parameters
 * @return string
 */
function nkolay_link($params) {
    // Gateway Configuration Parameters
    date_default_timezone_set("Europe/Istanbul");
    $apiKey = $params['apiKey'];
    $secretKey = $params['secretKey'];
    $threeDMode = isset($params['threeDMode']) && $params['threeDMode'] ? 'true' : 'false';
    $testMode = isset($params['testMode']) && $params['testMode'] ? 'on' : 'off';

    $systemUrl = $params['systemurl'];
    $successUrl = ensureHttps($systemUrl . 'modules/gateways/callback/nkolay.php');
    $failUrl = ensureHttps($systemUrl . 'modules/gateways/callback/nkolay.php');

    $amount = $params['amount'];
    $invoiceId = $params['invoiceid'];
    $clientRefCode = $invoiceId . 'WHMCS' . uniqid();

    $rnd = date("d.m.Y H:i:s");
    $transactionType = "SALES";

    // Hash data creation
    $hashString = $apiKey . $clientRefCode . $amount . $successUrl . $failUrl . $rnd . $secretKey;
    $hashData = base64_encode(pack('H*', sha1($hashString)));

    // Set test mode URL
    $url = $testMode === 'on' ? "https://paynkolaytest.nkolayislem.com.tr/Vpos" : "https://paynkolay.nkolayislem.com.tr/Vpos";

    // Prepare form data
    $formData = [
        'sx' => $apiKey,
        'successUrl' => $successUrl,
        'failUrl' => $failUrl,
        'amount' => $amount,
        'clientRefCode' => $clientRefCode,
        'use3D' => $threeDMode,
        'rnd' => $rnd,
        'transactionType' => $transactionType,
        'hashData' => $hashData,
        'ECOMM_PLATFORM' => 'WHMCS8x',
    ];

    if($params['instalment'] !== '' && $params['instalment'] >= 1) {
        $formData['instalments'] = $params['instalment'];
    }

    // Generate the form HTML
    $form = "<form method='post' action='" . $url . "'>";
    foreach ($formData as $key => $value) {
        $form .= "<input type='hidden' name='" . $key . "' value='" . htmlspecialchars($value, ENT_QUOTES, 'UTF-8') . "'>";
    }
    $form .= '<button type="submit" class="btn btn-primary">' . $params['langpaynow'] . '</button></form>';

    return $form;
}

/**
 * Ensure URL uses HTTPS.
 *
 * @param string $url
 * @return string
 */
function ensureHttps($url) {
    $parsedUrl = parse_url($url);

    if ($parsedUrl['scheme'] !== 'https') {
        return str_replace('http://', 'https://', $url);
    }

    return $url;
}

/**
 * Refund transaction.
 *
 * @param array $params
 * @return array|false
 */
function nkolay_refund($params) {
    
}
