<?php
/**
 * @package Give
 * @subpackage Nkolay Payment Gateway
 */
// Prevent to Direct Access
if (!defined('ABSPATH')) {
    exit();
}

if (!class_exists('Give_NKolay_Credit_Card')) {
    class Give_NKolay_Credit_Card
    {
        /**
         * @param string
         * Nkolay Ifields Version
         */

        protected $ifields_versions = '2.6.2006.0102';

        /**
         * Call all action method on class call
         * @access public
         */
        public function __construct()
        {
            // Add form on nkolay form
            add_action('give_nkolay_credit_card_cc_form', [$this, 'credit_card_form'], 10, 2);
            // process payemnt
            add_action('give_gateway_nkolay_credit_card', [$this, 'process_payment']);
        }
        /**
         * check if Nkolay details are available
         * @return boolean
         */
        public function isConfigured()
        {
            $xkey = trim(give_get_option('give_nkolay_sxkey'));
            $xifield = trim(give_get_option('give_nkolay_secret_key'));
            $status = true;

            if (!$xkey || !$xifield) {
                Give_Notices::print_frontend_notice(sprintf('<strong>%1$s</strong> %2$s', esc_html__('Notice:'), __('NKolay is not configurd, missing Transaction key or Token details', 'give-nkolay')));

                $status = false;
            }



            return $status;
        }

        /**
         * @param int $form_id
         * @param array $args
         * @return string $form
         * @since 0.0.1
         */
        public function credit_card_form($form_id, $args)
        {
            // Start Buffering html output
            ob_start();
            
            do_action('give_before_cc_fields', $form_id, $args);
            ?>

            <fieldset id="give_cc_fields" class="give-do-validate">
            <legend>
                <?php _e('Credit Card Details', 'give'); ?>
            </legend>

            </fieldset>

            <?php if(isset($_COOKIE['nkolay_error'])){

               Give_Notices::print_frontend_notice(sprintf(
                '<strong>%1$s</strong> %2$s',
                esc_html__('Credit Card Error:'),
                __($_COOKIE['nkolay_error'], 'give')
                ));

                setcookie('nkolay_error', null, -1, '/'); 
            }
                
            
            ?>
            <?php
            // Remove billing details fields
            $enable_billing_fields = give_get_option('give_nkolay_disable_address_fields');
            if ($enable_billing_fields == 'on') {
                remove_action('give_after_cc_fields', 'give_default_cc_address_fields');
            }

            do_action('give_after_cc_fields', $form_id, $args);

            // get and clean the buffering
            $form = ob_get_clean();

            echo $form;
        }

        // Process Payment
        public function process_payment($posted_data)
        {
            // Make sure we don't have any left over errors present.
            give_clear_errors();

            // Any errors?
            $errors = give_get_errors();
            //print_r($posted_data); exit;
            // No errors, proceed.
            if (!$errors) {
                $form_id = intval($posted_data['post_data']['give-form-id']);
                $price_id = !empty($posted_data['post_data']['give-price-id']) ? $posted_data['post_data']['give-price-id'] : 0;
                $donation_amount = !empty($posted_data['price']) ? $posted_data['price'] : 0;

                // Setup the payment details.
                $donation_data = [
                    'price' => $donation_amount,
                    'give_form_title' => $posted_data['post_data']['give-form-title'],
                    'give_form_id' => $form_id,
                    'give_price_id' => $price_id,
                    'date' => $posted_data['date'],
                    'user_email' => $posted_data['user_email'],
                    'purchase_key' => $posted_data['purchase_key'],
                    'currency' => give_get_currency($form_id),
                    'user_info' => $posted_data['user_info'],
                    'status' => 'pending',
                    'gateway' => 'NKolay',
                ];

                // Record the pending donation.
                $donation_id = give_insert_payment($donation_data);

                if (!$donation_id) {
                    // Record Gateway Error as Pending Donation in Give is not created.
                    give_record_gateway_error(
                        __('NKolay Error', 'give-nkolay'),
                        sprintf(
                            /* translators: %s Exception error message. */
                            __('Unable to create a pending donation with Give.', 'give-nkolay')
                        )
                    );

                    // Send user back to checkout.
                    give_send_back_to_checkout('?payment-mode=nkolay_credit_card&form_id=' . $form_id);
                    return;
                }

                $donation_id = give_get_option('give_nkolay_prefix') . $donation_id . '|G|' . uniqid() .  ' :: ' . $posted_data['user_info']['first_name'] . ' ' . $posted_data['user_info']['last_name'];

                $url = "https://paynkolay.nkolayislem.com.tr/Vpos";
                $use3D = give_get_option('give_nkolay_threed') == 'on' ? 'true' : 'false';
                $sx = give_get_option('give_nkolay_sxkey');
                $rnd = date("d.m.Y H:i:s");
                $detail = "false";
                $amount = $donation_amount;
                $merchantSecretKey = give_get_option('give_nkolay_secret_key');
                $transactionType = "SALES";
                $successUrl = get_site_url() . '/nkolaygive_callback?form_id=' . $form_id;
                $failUrl = get_site_url() . '/nkolaygive_callback?form_id=' . $form_id;
                $hashstr = $sx . $donation_id . $amount . $successUrl . $failUrl . $rnd . $merchantSecretKey;

                $hashData = base64_encode(pack('H*', sha1($hashstr)));
                $data = [
                    'sx' => $sx,
                    'successUrl' => $successUrl,
                    'failUrl' => $failUrl,
                    'amount' => $amount,
                    'clientRefCode' => $donation_id,

                    'use3D' => $use3D,
                    'rnd' => $rnd,

                    'detail' => $detail,
                    'transactionType' => $transactionType,
                    'hashData' => $hashData,
                ];

                $form = "<form id='nkolay-form' action='" . $url . "' method='post' target='_parent'>";
                foreach ($data as $key => $value) {
                    $form .= "<input type='hidden' name='" . $key . "' value='" . $value . "'>";
                }
                $form .= '<form><script>document.getElementById("nkolay-form").submit()</script>';
                //$form .= '<form>';

                echo $form;
                exit();
            } else {
                // Send user back to checkout.
                give_send_back_to_checkout('?payment-mode=nkolay_credit_card&form_id=' . $form_id);
            }
        }
    }
}