<?php
// app/code/local/Envato/Custompaymentmethod/Model/Paymentmethod.php
class Nkolay_NkolayPos_Model_Paymentmethod extends Mage_Payment_Model_Method_Abstract
{
    protected $_code = 'nkolaypos';
    protected $_formBlockType = 'nkolaypos/form_form';
    protected $_infoBlockType = 'nkolaypos/info_info';

    public function assignData($data)
    {
        Mage::getSingleton('core/session')->setData('nkolayParams', $_POST);
        return $this;
    }

    public function form()
    {
        $params = Mage::getSingleton('core/session')->getData('nkolayParams');
        $orderId = Mage::getSingleton('checkout/session')->getLastRealOrderId();
        $order = Mage::getSingleton('sales/order')->loadByIncrementId($orderId);
        $order->setPaymentMethod('nkolaypos');
        $order->save();

        
        date_default_timezone_set("Europe/Istanbul");
        $sx = Mage::getStoreConfig('payment/nkolaypos/sxkey');
		$merchantSecretKey = Mage::getStoreConfig('payment/nkolaypos/secretkey');
		$successUrl = Mage::getBaseUrl() . 'nkolay/payment/response';
		$failUrl = Mage::getBaseUrl() . 'nkolay/payment/response';
		$amount = $order->getGrandTotal();
		$clientRefCode = $order->getIncrementId() . '|MAGENTO|' . uniqid();
		$use3D = Mage::getStoreConfig('payment/nkolaypos/threed') == '1' ? 'true' : 'false'; 
		$rnd = date("d.m.Y H:i:s");
		$detail = "false";
		$transactionType = "SALES";
	
		$hashstr = $sx . $clientRefCode . $amount . $successUrl . $failUrl . $rnd . $merchantSecretKey; 
		
		$hashData = base64_encode(pack('H*',sha1($hashstr)));

		$data = [
			'sx' => $sx,
			'successUrl' => $successUrl,
			'failUrl' => $failUrl,
			'amount' => $amount,
			'clientRefCode' => $clientRefCode,

			'use3D' => $use3D,
			'rnd' => $rnd,

			'detail' => $detail,
			'transactionType' => $transactionType,
			'hashData' => $hashData,
		];

        return $data;
    }

    public function getOrderPlaceRedirectUrl()
    {
        return Mage::getUrl('nkolay/payment/redirect', ['_secure' => false]);
    }
}
