<?php

    namespace Nkolay\NkolayPos\Controller\Sanalpos;

    use Magento\Checkout\Model\Type\Onepage;
    use Magento\Framework\Controller\ResultFactory;
    use Magento\Framework\App\RequestInterface;
    use Magento\Framework\App\Request\InvalidRequestException;
    use Magento\Quote\Model\QuoteIdToMaskedQuoteIdInterface;

    class Response extends \Magento\Framework\App\Action\Action implements \Magento\Framework\App\CsrfAwareActionInterface
    {

        protected $_context;
        protected $_pageFactory;
        protected $_jsonEncoder;
        protected $_checkoutSession;
        protected $_customerSession;
        protected $_quote;
        protected $_cartManagement;
        protected $_resultRedirect;
        protected $_resultJsonFactory;
        protected $_quoteRepository;
        protected $_scopeConfig;
        protected $_request;
        protected $_messageManager;
        protected $_guestCartManagement;
        protected $_storeManager;
        protected $_quoteIdToMaskedQuoteId;


        public function __construct(
            \Magento\Framework\App\Action\Context                            $context,
            \Magento\Framework\Json\EncoderInterface                         $encoder,
            \Magento\Framework\View\Result\PageFactory                       $pageFactory,
            \Magento\Checkout\Model\Session                                  $checkoutSession,
            \Magento\Customer\Model\Session                                  $customerSession,
            \Magento\Quote\Model\Quote                                       $quote,
            \Magento\Quote\Api\CartManagementInterface                       $cartManagement,
            \Magento\Framework\Controller\ResultFactory                      $resultFactory,
            \Magento\Framework\Controller\Result\JsonFactory                 $resultJsonFactory,
            \Magento\Quote\Api\CartRepositoryInterface                       $quoteRepository,
            \Magento\Framework\App\Config\ScopeConfigInterface               $scopeConfig,
            \Magento\Framework\App\Request\Http                              $request,
            \Magento\Framework\Message\ManagerInterface                      $messageManager,
            \Magento\Checkout\Api\GuestPaymentInformationManagementInterface $guestCartManagement,
            \Magento\Store\Model\StoreManagerInterface                       $storeManager,
            QuoteIdToMaskedQuoteIdInterface                                  $quoteIdToMaskedQuoteId
        )
        {
            parent::__construct($context);
            $this->_resultJsonFactory = $resultJsonFactory;
            $this->_pageFactory = $pageFactory;
            $this->_jsonEncoder = $encoder;
            $this->_checkoutSession = $checkoutSession;
            $this->_customerSession = $customerSession;
            $this->_quote = $quote;
            $this->_cartManagement = $cartManagement;
            $this->_resultRedirect = $context->getResultFactory();
            $this->_quoteRepository = $quoteRepository;
            $this->_scopeConfig = $scopeConfig;
            $this->_request = $request;
            $this->_messageManager = $messageManager;
            $this->_guestCartManagement = $guestCartManagement;
            $this->_storeManager = $storeManager;
            $this->_quoteIdToMaskedQuoteId = $quoteIdToMaskedQuoteId;

        }

        public function execute()
        {



            $sandbox = $this->_scopeConfig->getValue('payment/nkolay_pos/sandbox');
            $url = "https://paynkolay.nkolayislem.com.tr/Vpos/Payment/CompletePayment";
            $post = $this->getRequest()->getPostValue();
            if ($sandbox == 1) {
                $url = "https://paynkolaytest.nkolayislem.com.tr/Vpos/Payment/CompletePayment";
            }
            $merchantSecretKey = $this->_scopeConfig->getValue('payment/nkolay_pos/merchantkey');
            $REFERENCE_CODE = $post['REFERENCE_CODE'];
            $RESPONSE_CODE = $post['RESPONSE_CODE'];
            $USE_3D = $post['USE_3D'];
            $MERCHANT_NO = $post['MERCHANT_NO'];
            $AUTH_CODE = $post['AUTH_CODE'];
            $CLIENT_REFERENCE_CODE = $post['CLIENT_REFERENCE_CODE'];
            $AUTHORIZATION_AMOUNT = $post['AUTHORIZATION_AMOUNT'];
            $INSTALLMENT = $post['INSTALLMENT'];
            $RND = $post['RND'];

            $hashtr = $MERCHANT_NO . $REFERENCE_CODE . $AUTH_CODE . $RESPONSE_CODE . $USE_3D . $RND . $INSTALLMENT . $AUTHORIZATION_AMOUNT . $merchantSecretKey;
            $hashDatauretilen = base64_encode(pack('H*', sha1($hashtr)));


            // Magento Data
            $resultRedirect = $this->_resultRedirect->create(ResultFactory::TYPE_REDIRECT);
            $checkoutSession = $this->_checkoutSession->getQuote();

            $payment_type = $checkoutSession->getPayment()->setMethod('nkolay_pos');

            $this->_quote = $this->_checkoutSession->getQuote();
            $customerId = 0;
            $billingAddress = $checkoutSession->getBillingAddress();

            if ($billingAddress->getEmail()) {
                $email = $billingAddress->getEmail();
            } else {

                $email = $this->_customerSession->getCustomer()->getEmail();
            }


            if ($this->_customerSession->isLoggedIn()) {
                $customerId = $this->_customerSession->getCustomerId();
            }




            if ($this->getRequest()->getPostValue('USE_3D') == 'false' && $this->getRequest()->getPostValue('hashData') == $hashDatauretilen) {
                if ($this->getRequest()->getPostValue('RESPONSE_CODE') == 2 && $this->getRequest()->getPostValue('hashData') == $hashDatauretilen) {

                    /*
                     * 2d işlem tamamlama
                     */


                    if ($this->_customerSession->isLoggedIn()) {
                        /* Place Order - Login Checkout */
                        $this->_cartManagement->placeOrder($checkoutSession->getId());

                    } else {
                        $quoteId = $this->getQuoteMaskId($checkoutSession->getId());
                        try {
                            $this->_guestCartManagement->savePaymentInformationAndPlaceOrder($quoteId, $email, $payment_type, $this->_checkoutSession->getBillingAddress());

                        } catch (\Exception $e) {
                            echo $e->getMessage();
                            exit;
                        }


                    }
                } else {

                    $this->_messageManager->addErrorMessage($this->getRequest()->getPostValue('RESPONSE_DATA'));
                    $resultRedirect->setPath('checkout/cart', ['_secure' => true]);
                    return $resultRedirect;
                }

            } else {



                /*
                 * 3d ödeme tamamlama bölümü
                 */


                if ($this->getRequest()->getPostValue('RESPONSE_CODE') == 2 && $this->getRequest()->getPostValue('hashData') == $hashDatauretilen) {
                    $ch = curl_init();
                    $arrData = array(
                        "sx" => $this->_scopeConfig->getValue('payment/nkolay_pos/sxkey'),
                        "referenceCode" => $REFERENCE_CODE
                    );
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $arrData);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    $server_output = curl_exec($ch);
                    $result = json_decode($server_output);
                    $result = json_decode($result->result);




                    if ($result->RESPONSE_CODE == 2) {


                        if ($this->_customerSession->isLoggedIn()) {

                            $this->_cartManagement->placeOrder($checkoutSession->getId());

                        } else {


                            $quoteId = $this->getQuoteMaskId($checkoutSession->getId());
                            try {

                                $this->_guestCartManagement->savePaymentInformationAndPlaceOrder($quoteId, $email, $payment_type, $this->_checkoutSession->getBillingAddress());
                            } catch (\Exception $e) {
                                echo $e->getMessage();
                                exit;
                            }
                        }
                    } else {

                        $this->_messageManager->addErrorMessage($result->RESPONSE_DATA);
                        $resultRedirect->setPath('checkout/cart', ['_secure' => true]);
                        return $resultRedirect;
                    }


                } else {

                    $this->_messageManager->addErrorMessage($this->getRequest()->getPostValue('RESPONSE_DATA'));
                    $resultRedirect->setPath('checkout/cart', ['_secure' => true]);
                    return $resultRedirect;
                }
            }


            $resultRedirect->setPath('checkout/onepage/success', ['_secure' => true]);
            return $resultRedirect;

        }


        /**
         * @inheritDoc
         */
        public function createCsrfValidationException(
            RequestInterface $request
        ): ?InvalidRequestException
        {
            return null;
        }

        /**
         * @inheritDoc
         */
        public function validateForCsrf(RequestInterface $request): ?bool
        {
            return true;
        }

        private function getQuoteMaskId($quoteId)
        {
            $maskedId = null;
            try {
                $maskedId = $this->_quoteIdToMaskedQuoteId->execute($quoteId);
            } catch (NoSuchEntityException $exception) {
                throw new LocalizedException(__('Current user does not have an active cart.'));
            }

            return $maskedId;
        }

        public function curl($par, $url)
        {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, array());
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $par);
            $output = curl_exec($ch);
            curl_close($ch);
            return $output;
        }

    }