<?php
/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Nkolay\NkolayPos\Model\Ui;

use Magento\Checkout\Model\ConfigProviderInterface;

use Magento\Framework\View\Asset\Source;


    
/**
 * Class ConfigProvider
 */
final class ConfigProvider implements ConfigProviderInterface
{


    /**
     * @var Repository
     */
    public $assetRepository;

    /**
     * @var StoreManagerInterface
     */
    public $storeManager;

    /**
     * @var ScopeConfigInterface
     */
    public $scopeConfig;

    /**
     * @var RequestInterface
     */
    public $request;

    /**
     * @var Loader
     */
    public $loader;

    /**
     * @var Utilities
     */
    public $utilities;

    /**
     * @var Logger
     */
    public $logger;
    public $_ccConfig;
    public $_assetSource;

    /**
     * Config constructor
     */
    public function __construct(
        \Magento\Framework\View\Asset\Repository $assetRepository,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\App\RequestInterface $request,
        \Magento\Payment\Model\CcConfig $ccConfig,
        Source $assetSource

    ) {
        $this->assetRepository = $assetRepository;
        $this->storeManager = $storeManager;
        $this->scopeConfig = $scopeConfig;
        $this->request = $request;
        $this->_ccConfig = $ccConfig;
        $this->_assetSource = $assetSource;

    }

    const CODE = 'nkolay_pos';
    protected $_methodCode = 'nkolay_pos';


    /**
     * Retrieve assoc array of checkout configuration
     *
     * @return array
     */
    public function getConfig()
    {
        return [
            'payment' => [
                self::CODE => [
                    'availableTypes' => [$this->_methodCode => $this->_ccConfig->getCcAvailableTypes()],
                    'months' => [$this->_methodCode => $this->_ccConfig->getCcMonths()],
                    'installments' => [$this->_methodCode => $this->installment()],
                    'years' => [$this->_methodCode => $this->_ccConfig->getCcYears()],
                    'is_api' => [$this->_methodCode => $this->scopeConfig->getValue('payment/nkolay_pos/cardform')],
                ]
            ]
        ];
    }

    public function fetchJavaScripts()
    {
        $script[] = 'Nkolay_NkolayPos::js/nkolay_pos.js';

        $scripts = '';
        foreach ($script as $key => $value) {
            $scripts .= $this->createScript($value);
        }

        return $scripts;
    }

    /**
     * @param string $script
     *
     * @return string
     */
    public function createScript($script)
    {
        return "
            <script type=\"text/javascript\">
   
                    $.getScript('{$this->generateURL($script)}');

            </script>";
    }

     /**
     * @param string $name
     *
     * @return string
     */
    public function generateURL($name)
    {
        return $this->assetRepository->createAsset($name)->getUrl();
    }

    public function installment()
    {
        return [
            '1' => 'Tek Çekim',
        ];
    }

    /**
     * Gets the module images path.
     *
     * @return array
     */
    public function getImagesPath()
    {
        return $this->assetRepository
        ->getUrl('Nkolay_NkolayPos::images');
    }

    /**
     * Gets the module CSS path.
     *
     * @return array
     */
    public function getCssPath()
    {
        return $this->assetRepository
        ->getUrl('Nkolay_NkolayPos::css');
    }
}
