<?php

/**
 * @since 1.5.0
 */
require_once dirname(__FILE__) . '/../../classes/Nkolay.php';
require_once dirname(__FILE__) . '/../../classes/Transaction.php';

class payment_nkolayPaymentModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {   
        parent::initContent();
        $currency = new Currency($this->context->cart->id_currency);
        $cart = $this->context->cart;

        if (!$this->module->checkCurrency($cart))
            Tools::redirect('index.php?controller=order');

        $this->context->controller->addJquery();


        $order_info                     = $this->context->cart;
        $customer                       = new Customer(intval($order_info->id_customer));
        $address                        = new Address(intval($order_info->id_address_invoice));
        $country                        = new Country(intval($address->id_country));
        $cart_products                  = $order_info->getProducts();
        $items                          = [];

        $site_url = explode("module", $_SERVER['SCRIPT_URI'])[0];
        $form['site_url'] = $site_url;
        $form['order_id'] = $this->context->cart->id;
        $form['payment_nkolay_form_turu'] = Configuration::get('payment_nkolay_form_turu');
        $form['amount'] = number_format($this->context->cart->getOrderTotal(), 2, '.', '');
        $form['url'] = Nkolay::$urls['checkout'][ Configuration::get('payment_nkolay_env') ];
        $form['params'] = [
            'sx' => Configuration::get('payment_nkolay_sx_key'),
            'successUrl' => $this->context->link->getModuleLink($this->module->name, 'validation', [], 1),
            'failUrl' => $this->context->link->getModuleLink($this->module->name, 'validation', [], 1),
            'amount' => number_format($this->context->cart->getOrderTotal(), 2, '.', ''),
            'merchantSecretKey' => Configuration::get('payment_nkolay_merchant_secret_key'),
            'clientRefCode' => 'PS_SIP_' . $this->context->cart->id . '_' . rand(100,999),
            'second' => "",
            'cardcampaign' => "",
            'bin' => "",
            'language' => "",//strtoupper($this->context->language->iso_code),
            'cardControl' => "",
            'nameSurname' => "",
            'use3d' => Configuration::get('payment_nkolay_3d_option') == '2d' ? 'false' : 'true',
            'rnd' => Date('d-m-Y H:i') .'000'. rand(10,99),
            'agentCode' => "",
            'detail' => "",
            'transactionType' => 'SALES',
        ];

        $hashstr = $form['params']['sx'] . $form['params']['clientRefCode'] . $form['params']['amount'] . $form['params']['successUrl'] . $form['params']['failUrl'] . $form['params']['rnd'] . $form['params']['merchantSecretKey'];
        $hashData = base64_encode(pack('H*',sha1($hashstr)));
        $form['params']['hashData'] = $hashData; 

        $this->context->smarty->assign([
            'nform' => $form,
        ]);
        $this->setTemplate('module:payment_nkolay/views/templates/front/payment_form.tpl');
        return;
    }
}
