<?php
    require_once dirname(__FILE__) . '/../../classes/Nkolay.php';

    /**
     * @since 1.5.0
     */
    class payment_nkolayd3StartModuleFrontController extends ModuleFrontController
    {
        /**
         * @see FrontController::postProcess()
         */
        public function postProcess()
        {


            if($_REQUEST['currency']==949 || $_REQUEST['currency'] == ""){

                $sx = Configuration::get('payment_nkolay_sx_key');
                $amount = $_REQUEST['odenecek_tutar'];
                $site_url = explode("/module", $_SERVER['SCRIPT_URI'])[0];

                $url = Nkolay::$urls['checkout'][Configuration::get('payment_nkolay_env')];


                $okUrl = $this->context->link->getModuleLink($this->module->name, 'validation', [], 1);
                $failUrl = $this->context->link->getModuleLink($this->module->name, 'validation', [], 1);
                $merchant_secret_key = Configuration::get('payment_nkolay_merchant_secret_key');
                $rnd = time();
                $clientRefCode = 'PS_SIP_' . $this->context->cart->id . '_' . $rnd;

                $hashstr = $sx . $clientRefCode . $amount . $okUrl . $failUrl . $rnd . $merchant_secret_key;
                $hashData = base64_encode(pack('H*', sha1($hashstr)));
                $vars = [
                    'sx' => $sx,
                    'clientRefCode' => $clientRefCode,
                    'successUrl' => $okUrl,
                    'failUrl' => $failUrl,
                    'amount' => $amount,
                    'installmentNo' => $_REQUEST['secilen_taksit'],
                    'cardHolderName' => $_REQUEST['cardHolderName'],
                    'month' => $_REQUEST['ay'],
                    'year' => $_REQUEST['yil'],
                    'cvv' => $_REQUEST['cvv'],
                    'cardNumber' => $_REQUEST['cardNumber'],
                    'EncodedValue' => $_REQUEST['tsx' . $_REQUEST['secilen_taksit']],
                    'use3D' => Configuration::get('payment_nkolay_3d_option') == '2d' ? 'false' : 'true',
                    'transactionType' => 'SALES',
                    'hosturl' => $site_url,
                    'rnd' => $rnd,
                    'hashData' => $hashData,
                    'environment' => 'API',
                ];
                $result = json_decode($this->curl($vars, $url . "/Payment/Payment"));
            } else {


                $this->context->smarty->assign([
                    'error_message' => "Paynkolay bu para birimi ile ödeme almayı desteklemiyor.",
                ]);

                $this->setTemplate('module:payment_nkolay/views/templates/front/payment_return.tpl');

                return;
            }


            if ($result->USE_3D == "false") {
                if ($result->RESPONSE_CODE == 2) {
                    $cart = $this->context->cart;

                    $nkolay = new Nkolay(
                        Configuration::get('payment_nkolay_sx_key'),
                        Configuration::get('payment_nkolay_merchant_secret_key'),
                        Configuration::get('payment_nkolay_env'),
                        Configuration::get('payment_nkolay_debug')
                    );
                    $customer = new Customer($this->context->customer->id);
                    if (!Validate::isLoadedObject($customer))
                        Tools::redirect('index.php?controller=order&step=1');
                    $currency = $this->context->currency;
                    $total = (float)$cart->getOrderTotal(true, Cart::BOTH);
                    $mailVars = array();

                    $customer_secure_key = false;
                    if ($customer and $customer->secure_key)
                        $customer_secure_key = $customer->secure_key;


                    $this->module->validateOrder($cart->id, Configuration::get('PS_OS_PAYMENT'), $total, $this->module->displayName, NULL, $mailVars, (int)$currency->id, false, $customer_secure_key);
                    Tools::redirect('index.php?controller=order-confirmation&id_cart=' . $cart->id . '&id_module=' . $this->module->id . '&id_order=' . $this->module->currentOrder . '&key=' . $customer_secure_key);

                }

            } else {
                if ($result->RESPONSE_CODE != 2) {

                    $this->context->smarty->assign([
                        'error_message' => $result->RESPONSE_DATA,
                    ]);
                    $this->setTemplate('payment_return.tpl');
                    return;

                } else {
                    print_r($result->BANK_REQUEST_MESSAGE);
                    exit;
                }
            }

        }

        public function curl($par, $url)
        {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, array());
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $par);
            $output = curl_exec($ch);
            curl_close($ch);
            return $output;
        }

    }
