<?php
/**
 * Plugin Name: Pay N Kolay
 * Plugin URI: https://paynkolay.com.tr
 * Description: Bu eklenti, Pay N Kolay WooCommerce Ödeme entegrasyonudur.
 * Version: 1.0.8
 *
 * Author: Pay N Kolay
 * Author URI: https://paynkolay.com.tr
 *
 * Text Domain: woocommerce-gateway-paynkolay
 * Domain Path: /i18n/languages/
 *
 * Requires at least: 4.2
 * Tested up to: 4.9
 *
 * Copyright: © 2009-2023 Meta-Bil.
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WC Paynkolay Payment gateway plugin class.
 *
 * @class WC_Paynkolay_Payments
 */
class WC_Paynkolay_Payments {

	/**
	 * Plugin bootstrapping.
	 */
	public static function init() {

		// Paynkolay Payments gateway class.
		add_action( 'plugins_loaded', array( __CLASS__, 'includes' ), 0 );

		// Make the Paynkolay Payments gateway available to WC.
		add_filter( 'woocommerce_payment_gateways', array( __CLASS__, 'add_gateway' ) );

		// Registers WooCommerce Blocks integration.
		add_action( 'woocommerce_blocks_loaded', array( __CLASS__, 'woocommerce_gateway_paynkolay_woocommerce_block_support' ) );

	}

	/**
	 * Add the Paynkolay Payment gateway to the list of available gateways.
	 *
	 * @param array
	 */
	public static function add_gateway( $gateways ) {

		$options = get_option( 'woocommerce_paynkolay_settings', array() );

		if ( isset( $options['hide_for_non_admin_users'] ) ) {
			$hide_for_non_admin_users = $options['hide_for_non_admin_users'];
		} else {
			$hide_for_non_admin_users = 'no';
		}

		if ( ( 'yes' === $hide_for_non_admin_users && current_user_can( 'manage_options' ) ) || 'no' === $hide_for_non_admin_users ) {
			$gateways[] = 'WC_Gateway_Paynkolay';
		}
		return $gateways;
	}

	/**
	 * Plugin includes.
	 */
	public static function includes() {

		// Make the WC_Gateway_Paynkolay class available.
		if ( class_exists( 'WC_Payment_Gateway' ) ) {
			require_once 'includes/class-wc-gateway-paynkolay.php';
		}
	}

	/**
	 * Plugin url.
	 *
	 * @return string
	 */
	public static function plugin_url() {
		return untrailingslashit( plugins_url( '/', __FILE__ ) );
	}

	/**
	 * Plugin url.
	 *
	 * @return string
	 */
	public static function plugin_abspath() {
		return trailingslashit( plugin_dir_path( __FILE__ ) );
	}

	/**
	 * Registers WooCommerce Blocks integration.
	 *
	 */
	public static function woocommerce_gateway_paynkolay_woocommerce_block_support() {
		if ( class_exists( 'Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType' ) ) {
			require_once 'includes/blocks/class-wc-paynkolay-payments-blocks.php';
			add_action(
				'woocommerce_blocks_payment_method_type_registration',
				function( Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry ) {
					$payment_method_registry->register( new WC_Gateway_Paynkolay_Blocks_Support() );
				}
			);
		}
	}
}

WC_Paynkolay_Payments::init();


add_action('template_redirect', 'failed_redirect');
function failed_redirect() {
	global $wp;

	$redirect_from = isset($_GET['redirect_from']) ? $_GET['redirect_from'] : null;
	$success = isset($_GET['success']) ? $_GET['success'] : null;

	if($redirect_from == 'paynkolay') {
		$current_url = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
		$current_url = remove_query_arg('redirect_from', $current_url);
		$current_url = add_query_arg('success', 'false', $current_url);
		wp_redirect($current_url);
	}

	if($success && $success == 'false') {
		$reason = isset($_GET['Reason']) ? $_GET['Reason'] : null;
		if($reason) {
			wc_add_notice(base64_decode($reason), 'error');
		} else {
			wc_add_notice(__('Ödeme işlemi başarısız oldu. Lütfen tekrar deneyin.', 'woocommerce-gateway-paynkolay'), 'error');
		}
	}

	/*
	if($success == 'false') {
		wc_add_notice(__('Ödeme işlemi başarısız oldu. Lütfen tekrar deneyin.', 'woocommerce-gateway-paynkolay'), 'error');
	}
	
	$pay_for_order = isset($_GET['pay_for_order']) ? $_GET['pay_for_order'] : null;
	$status = isset($_GET['status']) ? $_GET['status'] : null;
	if($pay_for_order && $status == 'failed') {
		$wc_get_cart_url = add_query_arg('success', 'false', wc_get_cart_url());
		wp_redirect($wc_get_cart_url);
		exit;
	}
	*/

	
}